const dbcita = require('../models/dbcita');

exports.listcitas = async function (req, res) {
    try {
        dbcita.getlistcitas(req.params.fechainicio,req.params.fechafin).then(
            result => {
                if (Object.entries(result[0]).length > 0) {
                    res.json(result[0]);
                } else {
                    res.json(
                        {
                            respuesta: 'no hay citas para la fecha'
                        }
                    )
                }
            }
        )
    } catch (err) {
        res.status(500).json(
            {
                error: err
            }
        );
    }
}

exports.listcitassicel = async function (req, res) {
    try {
        dbcita.getcellularmissing(req.params.fecha).then(
            result => {
                if (Object.entries(result[0]).length > 0) {
                    res.json(result);
                } else {
                    res.json(
                        {
                            respuesta: 'no hay citas con falta de celular para notificar'
                        }
                    )
                }
            }
        )
    } catch (err) {
        res.status(500).json(
            {
                error: err
            }
        );
    }
}

exports.listcitaspaciente = async function (req, res) {
    try {
        dbcita.getcitaspaciente(req.params.estado, req.params.paciente).then(
            result => {
                if (Object.entries(result[0]).length > 0) {
                    res.json(result);
                } else {
                    res.json(
                        {
                            respuesta: 'no hay registro de citas del paciente'
                        }
                    )
                }
            }
        )
    } catch (err) {
        res.status(500).json(
            {
                error: err
            }
        );
    }
}

exports.getcitapaciente = async function (req, res) {
    try {
        dbcita.getcita(req.params.id).then(
            result => {
                res.json(result[0]);
            }
        )
    } catch (err) {
        res.status(500).json(
            {
                error: err
            }
        );
    }
}